/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil; tab-width: 8 -*- */

/*-
 * Copyright (c) 2015, Howard Hughes Medical Institute
 *
 * Permission to use, copy, modify, and/or distribute this software
 * for any purpose with or without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include <errno.h>

#include "tvips.h"


/* XXX Only the case g == 5 is actually tested.
 */
int
tvips_g2fk(int g, int *f, int *k)
{
    switch (g) {
    case 0:
        *f = 0;
        *k = 0;
        return (0);

    case 1:
        *f = 1;
        *k = 0;
        return (0);

    case 2:
        *f = 1;
        *k = 2;
        return (0);

    case 3:
        *f = 0;
        *k = 2;
        return (0);

    case 4:
        *f = 0;
        *k = 3;
        return (0);

    case 5:
        *f = 1;
        *k = 1;
        return (0);

    case 6:
        *f = 1;
        *k = 3;
        return (0);

    case 7:
        *f = 0;
        *k = 1;
        return (0);

    case 8:
    case 12:
        *f = 0;
        *k = 2;
        return (0);

    case 9:
    case 13:
        *f = 1;
        *k = 2;
        return (0);

    case 10:
    case 14:
        *f = 1;
        *k = 0;
        return (0);

    case 11:
    case 15:
        *f = 0;
        *k = 0;
        return (0);

    case 16:
        *f = 0;
        *k = 1;
        return (0);

    case 17:
        *f = 1;
        *k = 3;
        return (0);

    case 18:
        *f = 1;
        *k = 1;
        return (0);

    case 19:
        *f = 0;
        *k = 3;
        return (0);
    }

    errno = EINVAL;
    return (-1);
}
